' Program ENC_DEMO.BAS
' Rotary Encoder Reader

' To read the Rotary encoder call the subroutine ENCODER
' Upon its return, the variable DIRECTION will hold the specific direction of the encoder
' A result of 128 (Bit-7) means encoder turning left
' A result of 1 (Bit-0) means encoder turning right
' A result of 0 means the encoder is stationary

' Two new defines establish which Port and pins the Rotary encoder is attached to
' These are: -

'	Define	ENC_PORT
'	Define  ENC_BIT		

' ENC_PORT defines which PORT the encoder is attached to
' ENC_BIT defines which BIT Channel-A of the encoder is attached to
' Channel-B of the encoder must be attached to the next bit up
' For instance if the define ENC_BIT is given the value 0 then
' Channel-A will be attached to PortB.0, and Channel-B will be attached to PortB.1

' The result is sent serially from PortA.0

	INCLUDE "Modedefs.Bas"


' ** Set Xtal Value in Mhz

	DEFINE	OSC		4		' Set Xtal Frequency


' ** Set Debug Defines **

	DEFINE	DEBUG_REG	PORTA		' Debug PORT ?
	DEFINE	DEBUG_BIT	0		' *** Debug pin Bit ? ***
	DEFINE	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	DEFINE	DEBUG_MODE	1		' Set Serial Mode 0=True, 1=Inverted
	DEFINE	DEBUG_PACING	100		' Delay 'in us' between characters sent


	Counter		VAR	WORD		' General Purpose counter for Demo Loop
	Enc_Temp	VAR	BYTE		' Temporary variable for Encoder subroutine
	Direction   	VAR 	BYTE	SYSTEM	' Direction bit FLAGs If Bit-0=1 then turning right
' If Bit-7=1 then turning left
	Enc_Old 	VAR 	BYTE		' Original value of Encoder State
	Enc_New 	VAR 	BYTE		' New value of Encoder State
	Enc_Mask	VAR	BYTE		' Value to MASK the Encoder Pins


' ** New Defines for Rotary Encoder **

	DEFINE	ENC_PORT	PORTB		' Encoder Port
	DEFINE	ENC_BIT		0		' Encoder CH-A Bit,CH-B bit is the next bit up
	

	Pause 400
	Debug I,Clr:Pause 30			' Clear the LCD

Asm
; Set the default PORT AND BITS to PORTB, bits 0-1
	ifndef ENC_PORT
ENC_PORT=PORTB
	EndIF
	ifndef ENC_BIT
ENC_BIT=0
	EndIF

; ** Determine IF PORTB is being used **
; ** IF it is Then Enable PORTB Pullups **
	IF (ENC_PORT == PORTB)
	Bsf Status,5				; Point to Page1
	Bcf OPTION_REG,7			; Enable the pullup resistors
	Bcf Status,5				; Back to Page0
	EndIF

; ** Assign the Specified Port AND Bits as Inputs **

	Bcf ENC_PORT,ENC_BIT			;' Clear the appropriate pin for channel-A
	Bcf ENC_PORT,ENC_BIT+1			;' Clear the appropriate pin for channel-B
	Bsf Status,5				;' Point to Page1
	Bsf ENC_PORT,ENC_BIT			;' Make the channel-A pin an input
	Bsf ENC_PORT,ENC_BIT+1			;' Make the channel-B pin an input
	Bcf Status,5				;' Back to Page0

;' Adjust the MASK value according to the ENC_BIT define
	Clrf _Enc_Mask				; Clear the Enc_Mask variable
	IF (ENC_BIT == 0)
	Movlw 00000011b
	EndIF

	IF (ENC_BIT == 1)
	Movlw 00000110b
	EndIF

	IF (ENC_BIT == 2)
	Movlw 00001100b
	EndIF

	IF (ENC_BIT == 3)
	Movlw 00011000b
	EndIF

	IF (ENC_BIT == 4)
	Movlw 00110000b
	EndIF

	IF (ENC_BIT == 5)
	Movlw 01100000b
	EndIF

	IF (ENC_BIT == 6)
	Movlw 11000000b
	EndIF

	Iorwf _Enc_Mask				; Superimpose the bits into ENC_MASK
	Movf ENC_PORT,w				; Read the Value of the appropriate Port
	Movwf _Enc_Old				; AND store it in ENC_OLD
	Movf _Enc_Mask,w			; Get the ENC_MASK Value
	Andwf _Enc_Old,f			; AND it with _ENC_OLD to Enc_Mask the correct bits
EndAsm

' ** MAIN DEMO LOOP STARTS HERE **

	Counter=0
Loop:	GoSub Encoder
	IF Direction.0=1 Then Counter=Counter+1
	IF Direction.7=1 Then Counter=Counter-1
	Debug I,Line2,#Counter,"    "
	GoTo Loop


' Read the status of the Rotary encoder
' The variable DIRECTION has 2 bits set for the specific direction
' DIRECTION.7=1 when the Rotary encoder is turning LEFT
' DIRECTION.0=1 when the Rotary encoder is turning RIGHT
Encoder:
Asm 
	Clrf Direction			; Clear the Return variable before The subroutine
	Mov _Enc_New,ENC_PORT		; Get latest state of Input bits.
	AND _Enc_New,_Enc_Mask		; Strip off all but the encoder bits.
	Mov _Enc_Temp,_Enc_New		; Save the value of ENC_NEW
	XOR _Enc_Temp, _Enc_Old 	; Does Enc_New = Enc_Old?
	Jz N_Exit 			; IF so, Exit Without Change
	Clc 				; Clear carry in preparation For rotate-left instruction.
	Rlf _Enc_Old 			; Move ENC_OLD to the left to align ENC_OLD with ENC_NEW.
	XOR _Enc_Old,_Enc_New		; XOR ENC_NEW with ENC_OLD
	Btfsc _Enc_Old,ENC_BIT+1	; IF the XOR result is 1
	GoTo Left			; Then jump to Direction For left turn. Else
Right 	Bsf Direction,0			; Set Direction BIT-0 For right turn
	GoTo Exit			; Exit Subroutine
Left 	Bsf Direction,7			; Set Direction BIT-7 For left turn

Exit	Movf _Enc_New,w
	Movwf _Enc_Old			; ENC_OLD now equals ENC_NEW
N_Exit
EndAsm
	Return				' Exit Subroutine

 
